<?php
session_start();
include 'backend/db.php';

// ۱. بررسی لاگین بودن کاربر
if (!isset($_SESSION['namef'])) {
    die("خطا: دسترسی غیرمجاز. لطفا وارد شوید.");
}
$user_fullname = $_SESSION['namef'];

$stmt = $conn->prepare("SELECT id FROM users WHERE fullname = ?");
$stmt->bind_param("s", $user_fullname);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user) {
    die("خطا: کاربر در دیتابیس پیدا نشد.");
}
$user_id = $user['id'];

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // دریافت مقادیر
    $exam_name = isset($_POST['exam_name']) ? $_POST['exam_name'] : 'نامشخص';
    $score = isset($_POST['score']) ? $_POST['score'] : 0;
    $duration = isset($_POST['duration']) ? $_POST['duration'] : 0;
   

    // ۴. ذخیره در دیتابیس
    $sql = "INSERT INTO exams (user_id, exam_name, score, duration) VALUES (?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    
    if ($stmt) {
        $stmt->bind_param("isdi", $user_id, $exam_name, $score, $duration);
        
        if ($stmt->execute()) {
           
            echo "Success";
        } else {
            echo "Error: " . $stmt->error;
        }
        $stmt->close();
    } else {
        echo "Error: " . $conn->error;
    }
}
?>