<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include 'backend/db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // دریافت ورودی‌ها
    $fullname = trim($_POST['fullname']);
    $username = trim($_POST['username']);
    $mobile = trim($_POST['mobile']);
    $pass = $_POST['password']; 
    $grade = $_POST['grade'];

    // --- 1. بررسی یونیک بودن نام کاربری ---
    $checkUser = $conn->prepare("SELECT id FROM users WHERE username = ?");
    $checkUser->bind_param("s", $username);
    $checkUser->execute();
    $checkUser->store_result();

    if ($checkUser->num_rows > 0) {
        echo "<script>alert('این نام کاربری قبلاً گرفته شده است. لطفاً نام دیگری انتخاب کنید.'); window.history.back();</script>";
        exit();
    }
    $checkUser->close();

    // --- 2. بررسی یونیک بودن شماره موبایل ---
    $checkMobile = $conn->prepare("SELECT id FROM users WHERE mobile = ?");
    $checkMobile->bind_param("s", $mobile);
    $checkMobile->execute();
    $checkMobile->store_result();

    if ($checkMobile->num_rows > 0) {
        echo "<script>alert('این شماره موبایل قبلاً در سیستم ثبت شده است.'); window.history.back();</script>";
        exit();
    }
    $checkMobile->close();

    // --- 3. هش کردن رمز عبور (امنیت) ---
    $hashed_password = password_hash($pass, PASSWORD_DEFAULT);
    // --- 4. ذخیره در دیتابیس ---
    $sql = "INSERT INTO users (fullname, username, mobile, password, grade) VALUES (?, ?, ?, ?, ?)";
    
    $stmt = $conn->prepare($sql);
    
    if ($stmt) {
        $stmt->bind_param("ssssi", $fullname, $username, $mobile, $hashed_password, $grade);
        
        if ($stmt->execute()) {
         
            $_SESSION['namef'] = $fullname;
            $_SESSION['grade'] = $grade; 
            
            echo "<script>alert('ثبت نام با موفقیت انجام شد!'); window.location.href = 'profile.php';</script>";
        } else {
            echo "خطا در اجرا: " . $stmt->error;
        }
        $stmt->close();
    } else {
        echo "خطا در آماده‌سازی کوئری: " . $conn->error;
    }
}
$conn->close();
?>