<?php
session_start();
include 'db.php';

// بررسی لاگین
if (!isset($_SESSION['namef'])) {
    header("Location: index.html");
    exit();
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>روند پیشرفت</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/Vazirmatn-font-face.css" rel="stylesheet" type="text/css" />
    <link href="css/profili.style.css" rel="stylesheet" type="text/css" />
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="body">
    <!-- هدر و منو -->
    <div class="mobile-overlay" id="mobileOverlay" onclick="toggleMenu()"></div>
    <div class="mobile-sidebar" id="mobileSidebar">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
            <span style="font-weight: 900; font-size: 1.2rem; color: #fff;">منو</span>
            <div onclick="toggleMenu()" style="cursor: pointer; color: #fff;">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="18" y1="6" x2="6" y2="18"/><line x1="6" y1="6" x2="18" y2="18"/></svg>
            </div>
        </div>
        <nav class="mobile-menu-list">
            <a href="profile.php" onclick="toggleMenu()"><i class="bi bi-house-door" style="margin-left: 15px;"></i>خانه</a>
            <a href="#" onclick="toggleMenu()"><i class="bi bi-card-checklist" style="margin-left: 15px;"></i>تست ها</a>
            <a href="progress.php" onclick="toggleMenu()" style="color: var(--primary-neon);"><i class="bi bi-graph-up-arrow" style="margin-left: 15px;"></i>روند پیشرفت</a>
            <a href="logout.php" onclick="toggleMenu()" style="color: #ef4444;">خروج</a>
        </nav> 
    </div>

    <header>
        <div class="container navbar">
            <div class="logo">آزمون‌یار</div>
            <ul class="nav-menu-desktop">
            <li><a href="profile.php" class="nav-link">داشبورد</a></li>
            <li><a href="#" class="nav-link">تست ها</a></li>
            <li><a href="progress.php" class="nav-link active">روند پیشرفت</a></li>
            <li><a href="logout.php" class="nav-link" style="color: #ef4444;">خروج</a></li>
            </ul>
            <div class="hamburger" onclick="toggleMenu()">
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="3" y1="12" x2="21" y2="12"/><line x1="3" y1="6" x2="21" y2="6"/><line x1="3" y1="18" x2="21" y2="18"/></svg>
            </div>
        </div>
    </header>

    <div class="container main-content">
        <!-- سایدبار -->
        <aside class="sidebar">
            <div class="glass-card profile-info">
                <div class="avatar">
                    <svg width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/><circle cx="12" cy="7" r="4"/></svg>
                </div>
                <?php 
                if ( $_SESSION['grade'] == 7){ $paye = 'پایه هفتم'; }
                if ( $_SESSION['grade'] == 8){ $paye = 'پایه هشتم '; }
                if ( $_SESSION['grade'] == 9){ $paye = 'پایه نهم'; }
                ?>
                <h3 class="user-name"><?php echo $_SESSION['namef']; ?></h3>
                <p class="user-role"><?php echo $paye ;?></p>
                <a href="duros.html">
                    <button class="btn-neon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="fs"><polygon points="5 3 19 12 5 21 5 3"/></svg>
                        شروع آزمون جدید
                    </button>
                </a>
            </div>
            <div class="glass-card">
                <nav class="sidebar-menu">
                    <a href="profile.php">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="3" y="3" width="7" height="7"/><rect x="14" y="3" width="7" height="7"/><rect x="14" y="14" width="7" height="7"/><rect x="3" y="14" width="7" height="7"/></svg>
                        داشبورد
                    </a>
                    <a href="progress.php" class="active">
                        <i class="bi bi-graph-up-arrow"></i>روند پیشرفت
                    </a>
                    <a href="#">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="3"/><path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"/></svg>
                        تنظیمات
                    </a>
                </nav>
            </div>
        </aside>

        <!-- محتوای اصلی (فقط نمودار) -->
        <section class="dashboard-area">
            <div>
                <h2 class="section-title">روند پیشرفت تحصیلی</h2>
                <div class="glass-card" style="position: relative; height: 400px; width: 100%;">
                    <canvas id="progressChart"></canvas>
                </div>
            </div>
        </section>
    </div>

    <script>
        function toggleMenu() {
            const sidebar = document.getElementById('mobileSidebar');
            const overlay = document.getElementById('mobileOverlay');
            sidebar.classList.toggle('active');
            overlay.classList.toggle('active');
        }

        // دریافت داده‌ها برای نمودار
        const ctx = document.getElementById('progressChart').getContext('2d');
        
        // داده‌های نمودار (اینجا باید از PHP دریافت بشن، فعلاً نمونه قرار میدم)
        // برای اینکه داده‌های واقعی رو ببینی، باید کد PHP دریافت دیتابیس رو اینجا هم بذاری
        // من کد PHP رو پایین اسکریپت قرار میدم تا کار کنه:
    </script>

    <?php
    // دریافت داده‌های نمودار از دیتابیس
    $user_fullname = $_SESSION['namef']; 
    $stmt = $conn->prepare("SELECT id FROM users WHERE fullname = ?");
    $stmt->bind_param("s", $user_fullname);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();

    if ($user) {
        $user_id = $user['id'];
        $chart_sql = "SELECT exam_date, score FROM exams WHERE user_id = ? ORDER BY exam_date ASC LIMIT 10";
        $stmt = $conn->prepare($chart_sql);
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $chart_res = $stmt->get_result();
        
        $chart_labels = [];
        $chart_data = [];
        
        while ($row = $chart_res->fetch_assoc()) {
            $dateObj = date_create($row['exam_date']);
            $chart_labels[] = date_format($dateObj, 'Y/m/d'); 
            $chart_data[] = $row['score'];
        }
    }
    ?>

    <script>
        const chartLabels = <?php echo json_encode($chart_labels); ?>;
        const chartData = <?php echo json_encode($chart_data); ?>;

        const progressChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: chartLabels,
                datasets: [{
                    label: 'نمره آزمون',
                    data: chartData,
                    borderColor: '#22d3ee',
                    backgroundColor: 'rgba(34, 211, 238, 0.1)',
                    borderWidth: 3,
                    pointBackgroundColor: '#a855f7',
                    pointBorderColor: '#fff',
                    pointRadius: 5,
                    pointHoverRadius: 7,
                    fill: true,
                    tension: 0.4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        labels: {
                            color: '#f1f5f9',
                            font: { family: 'sans' }
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        max: 20,
                        grid: { color: 'rgba(255, 255, 255, 0.1)' },
                        ticks: { color: '#94a3b8' }
                    },
                    x: {
                        grid: { display: false },
                        ticks: { color: '#94a3b8' }
                    }
                }
            }
        });
    </script>
</body>
</html>