<?php
session_start();
include 'backend/db.php';
// بررسی لاگین
if (!isset($_SESSION['namef'])) {
    header("Location: index.html");
    exit();
}

// متغیرهای نمودار
$chart_labels = [];
$chart_data = [];
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title> تستینو |  پروفایل کاربری  </title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/Vazirmatn-font-face.css" rel="stylesheet" type="text/css" />
    <link href="css/profili.style.css" rel="stylesheet" type="text/css" />
    <link rel="icon" type="image/png" href="img/icon.png">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="body">
    <!-- منوی موبایل -->
    <div class="mobile-overlay" id="mobileOverlay" onclick="toggleMenu()"></div>
    <div class="mobile-sidebar" id="mobileSidebar">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
            <span style="font-weight: 900; font-size: 1.2rem; color: #fff;">منو</span>
            <div onclick="toggleMenu()" style="cursor: pointer; color: #fff;">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="18" y1="6" x2="6" y2="18"/><line x1="6" y1="6" x2="18" y2="18"/></svg>
            </div>
        </div>
        <nav class="mobile-menu-list">
            <a href="#" onclick="toggleMenu()"><i class="bi bi-house-door" style="margin-left: 15px;"></i>خانه</a>
            <a href="duros.html" onclick="toggleMenu()"><i class="bi bi-card-checklist" style="margin-left: 15px;"></i>تست ها</a>
            <a href="#" onclick="toggleMenu()"><i class="bi bi-graph-up-arrow" style="margin-left: 15px;"></i>روند پیشرفت</a>
            <a href="#" onclick="toggleMenu()" style="color: #ef4444;">خروج</a>
        </nav> 
    </div>

    <header>
        <div class="container navbar">
        <img src="img/logo1.png" class="logo1"  >
                <ul class="nav-menu-desktop">
            <li><a href="profile.php" class="nav-link">داشبورد</a></li>
            <li><a href="#" class="nav-link">تست ها</a></li>
            <li><a href="#" class="nav-link">روند پیشرفت</a></li>
            <li><a href="logout.php" class="nav-link" style="color: #ef4444;">خروج</a></li>
            </ul>
            <div class="hamburger" onclick="toggleMenu()">
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="3" y1="12" x2="21" y2="12"/><line x1="3" y1="6" x2="21" y2="6"/><line x1="3" y1="18" x2="21" y2="18"/></svg>
            </div>
        </div>
    </header>

    <div class="container main-content">
        <!-- سایدبار -->
        <aside class="sidebar">
            <div class="glass-card profile-info">
                <div class="avatar">
                    <svg width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/><circle cx="12" cy="7" r="4"/></svg>
                </div>
                <?php 
                if ( $_SESSION['grade'] == 7){ $paye = 'پایه هفتم'; }
                if ( $_SESSION['grade'] == 8){ $paye = 'پایه هشتم '; }
                if ( $_SESSION['grade'] == 9){ $paye = 'پایه نهم'; }
                ?>
                <h3 class="user-name"><?php echo $_SESSION['namef']; ?></h3>
                 <p class="user-role"><?php  echo $paye ;?></p>
                <a href="duros.html">
                    <button class="btn-neon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="fs"><polygon points="5 3 19 12 5 21 5 3"/></svg>
                        شروع آزمون جدید
                    </button>
                </a>
            </div>
            <div class="glass-card">
                <nav class="sidebar-menu">
                    <!-- لینک داشبورد -->
                    <a href="#" onclick="showDashboard()">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="3" y="3" width="7" height="7"/><rect x="14" y="3" width="7" height="7"/><rect x="14" y="14" width="7" height="7"/><rect x="3" y="14" width="7" height="7"/></svg>
                        داشبورد
                    </a>
                    <!-- لینک نمودار -->
                    <a href="#" onclick="showChart()">
                        <i class="bi bi-graph-up-arrow"></i>روند پیشرفت
                    </a>
            
    <a href="#"  onclick="showCompetitionModal()">
                        <i class="bi bi-people-fill"></i>رقابت 
                    </a>
                </nav>
            </div>
        </aside>

        <!-- محتوای اصلی -->
        <section class="dashboard-area">
            
            <!-- بخش آمار و جدول (داشبورد) -->
            <div id="dashboard-view">
                <h2 class="section-title">آمار کلی</h2>
                <div class="stats-grid">
                <?php
                // دریافت اطلاعات کاربر
                $user_fullname = $_SESSION['namef']; 
                $stmt = $conn->prepare("SELECT id FROM users WHERE fullname = ?");
                $stmt->bind_param("s", $user_fullname);
                $stmt->execute();
                $result = $stmt->get_result();
                $user = $result->fetch_assoc();
                
                if ($user) {
                    $user_id = $user['id'];
                    
                    // --- دریافت داده‌های نمودار ---
                    $chart_sql = "SELECT exam_date, score FROM exams WHERE user_id = ? ORDER BY exam_date ASC LIMIT 10";
                    $stmt = $conn->prepare($chart_sql);
                    $stmt->bind_param("i", $user_id);
                    $stmt->execute();
                    $chart_res = $stmt->get_result();
                    
                    while ($row = $chart_res->fetch_assoc()) {
                        $dateObj = date_create($row['exam_date']);
                        $chart_labels[] = date_format($dateObj, 'Y/m/d'); 
                        $chart_data[] = $row['score'];
                    }

                    // آمارها
                    $count_sql = "SELECT COUNT(*) as total_exams FROM exams WHERE user_id = ?";
                    $stmt = $conn->prepare($count_sql);
                    $stmt->bind_param("i", $user_id);
                    $stmt->execute();
                    $count_res = $stmt->get_result();
                    $count_row = $count_res->fetch_assoc();
                    $total_exams = $count_row['total_exams'];
                    
                    $avg_sql = "SELECT AVG(score) as avg_score FROM exams WHERE user_id = ?";
                    $stmt = $conn->prepare($avg_sql);
                    $stmt->bind_param("i", $user_id);
                    $stmt->execute();
                    $avg_res = $stmt->get_result();
                    $avg_row = $avg_res->fetch_assoc();
                    $avg_score = $avg_row['avg_score'];
                    if ($avg_score == null) { $avg_score = 0; } else { $avg_score = round($avg_score, 1); }
                       
                    $time_sql = "SELECT SUM(duration) as total_time FROM exams WHERE user_id = ?";
                    $stmt = $conn->prepare($time_sql);
                    $stmt->bind_param("i", $user_id);
                    $stmt->execute();
                    $time_res = $stmt->get_result();
                    $time_row = $time_res->fetch_assoc();
                    $total_seconds = $time_row['total_time'];
                    if ($total_seconds == null) { $total_time = 0; } else {
                        $total_minutes = round($total_seconds / 60);
                        if ($total_minutes < 1) { $total_time = 1; } else { $total_time = $total_minutes; }
                    }
                }
                ?>
                <!-- کارت‌ها -->
                <div class="glass-card stat-card">
                    <div class="stat-icon">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/><polyline points="22 4 12 14.01 9 11.01"/></svg>
                    </div>
                    <div class="stat-info">
                        <h3><?php echo $total_exams; ?></h3>
                        <p>آزمون موفق</p>
                    </div>
                </div>
                <div class="glass-card stat-card">
                    <div class="stat-icon" style="color: var(--secondary-neon);">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="12" y1="1" x2="12" y2="23"/><path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/></svg>
                    </div>
                    <div class="stat-info">
                        <h3><?php echo $avg_score; ?></h3>
                        <p>میانگین نمرات</p>
                    </div>
                </div>
                <div class="glass-card stat-card">
                    <div class="stat-icon" style="color: #fbbf24;">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="10"/><polyline points="12 6 12 12 16 14"/></svg>
                    </div>
                    <div class="stat-info">
                        <h3><?php echo $total_time; ?></h3>
                        <p>دقیقه مطالعه</p>
                    </div>
                </div>
            </div>
            <br>
            
            <!-- جدول -->
            <div>
                <h2 class="section-title">تاریخچه آزمون‌ها</h2>
                <div class="glass-card table-responsive">
                    <table>
                        <thead>
                            <tr>
                                <th>نام درس</th>
                                <th>تاریخ</th>
                                <th>نمره</th>
                                <th>مدت زمان</th>
                                <th>وضعیت</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $history_sql = "SELECT exam_name, score, duration, exam_date FROM exams WHERE user_id = ? ORDER BY exam_date DESC LIMIT 5";
                            $stmt = $conn->prepare($history_sql);
                            $stmt->bind_param("i", $user_id);
                            $stmt->execute();
                            $history_res = $stmt->get_result();
                            if ($history_res->num_rows > 0) {
                                while ($row = $history_res->fetch_assoc()) {
                                    $date = date('Y-m-d', strtotime($row['exam_date']));
                                    $score = $row['score'];
                                    
                                    if ($score >= 18) {
                                        $statusBadge = '<span style="background-color: #10b98157; color: white; padding: 5px 10px; border-radius: 20px; font-size: 0.85rem; font-weight: bold;">بسیار عالی</span>';
                                    } elseif ($score >= 14) {
                                        $statusBadge = '<span style="background-color: #ffeb3b61; color: white; padding: 5px 10px; border-radius: 20px; font-size: 0.85rem; font-weight: bold;">خوب </span>';
                                    } else {
                                        $statusBadge = '<span style="background-color: #ef444445; color: white; padding: 5px 10px; border-radius: 20px; font-size: 0.85rem; font-weight: 500;">نیاز به تلاش</span>';
                                    }
                                    
                                    echo "<tr>";
                                    echo "<td>" . $row['exam_name'] . "</td>";
                                    echo "<td>" . $date . "</td>";
                                    echo "<td>" . $score . "</td>";
                                    $durationRaw = $row['duration'];
                                    if ($durationRaw < 60) { $timeDisplay = "۱ دقیقه"; } else { $minutes = round($durationRaw / 60); $timeDisplay = $minutes . " دقیقه"; }
                                    echo "<td>" . $timeDisplay . "</td>";
                                    echo "<td>" . $statusBadge . "</td>";
                                    echo "</tr>";
                                }
                            } else {
                                echo "<tr><td colspan='5' style='text-align:center; color:#aaa; padding: 20px;'>هنوز آزمونی ثبت نشده است.</td></tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
            </div> 

            <!-- بخش نمودار (مخفی در ابتدا) -->
            <div id="chart-view" style="display: none;">
                <h2 class="section-title">روند پیشرفت تحصیلی</h2>
                <div class="glass-card" style="position: relative; height: 400px; width: 100%;">
                    <canvas id="progressChart"></canvas>
                </div>
            </div>

        </section>
    </div>
             <!-- مودال رقابت (مشابه سبک duros.html) -->
    <div class="modal-overlay" id="competitionModal">
        <div class="modal-box">
            <div class="modal-icon">
                <i class="bi bi-emoji-frown"></i>
            </div>
            <h3 class="modal-title">قابلیت غیرفعال</h3>
            <p class="modal-text">متأسفانه امکان رقابت آنلاین با سایر دانش‌آموزان هنوز وجود ندارد.</p>
            <button class="modal-btn" onclick="closeCompetitionModal()">متوجه شدم</button>
        </div>
    </div>
    <script>
        function toggleMenu() {
            const sidebar = document.getElementById('mobileSidebar');
            const overlay = document.getElementById('mobileOverlay');
            sidebar.classList.toggle('active');
            overlay.classList.toggle('active');
        }

        // تابع نمایش داشبورد
        function showDashboard() {
            document.getElementById('dashboard-view').style.display = 'block';
            document.getElementById('chart-view').style.display = 'none';
        }

        // تابع نمایش نمودار
        function showChart() {
            document.getElementById('dashboard-view').style.display = 'none';
            document.getElementById('chart-view').style.display = 'block';
        }

        // رسم نمودار در زمان لود صفحه
        document.addEventListener("DOMContentLoaded", function() {
            const ctx = document.getElementById('progressChart');
            if (ctx) {
                const chartLabels = <?php echo json_encode($chart_labels); ?>;
                const chartData = <?php echo json_encode($chart_data); ?>;
                
                if (chartData.length === 0) {
                    ctx.parentNode.innerHTML = '<p style="text-align:center; color:#aaa; padding-top:150px;">هنوز آزمونی ثبت نشده است.</p>';
                } else {
                    new Chart(ctx, {
                        type: 'line',
                        data: {
                            labels: chartLabels,
                            datasets: [{
                                label: 'نمره آزمون',
                                data: chartData,
                                borderColor: '#22d3ee',
                                backgroundColor: 'rgba(34, 211, 238, 0.1)',
                                borderWidth: 3,
                                pointBackgroundColor: '#a855f7',
                                pointBorderColor: '#fff',
                                pointRadius: 5,
                                fill: true,
                                tension: 0.4
                            }]
                        },
                        options: {
                            responsive: true,
                            maintainAspectRatio: false,
                            plugins: {
                   legend: {
                      display: false 
                  }
                   },
                            scales: {
                                y: { beginAtZero: true, max: 20, grid: { color: 'rgba(255, 255, 255, 0.1)' }, ticks: { color: '#94a3b8' } },
                                x: { grid: { display: false }, ticks: { color: '#94a3b8' } }
                            }
                        }
                    });
                }
            }
        });
                      
        function showCompetitionModal() {
            document.getElementById('competitionModal').classList.add('active');
        }

        
        function closeCompetitionModal() {
            document.getElementById('competitionModal').classList.remove('active');
        }

        document.getElementById('competitionModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeCompetitionModal();
            }
        });
    </script>
</body>
</html>