<?php
session_start(); // حتماً باید در اولین خط باشد
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include 'backend/db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    $identifier = $_POST['user_identifier'];
    $pass = $_POST['password'];
    
    // جستجو بر اساس نام کاربری یا موبایل
    $sql = "SELECT id, fullname, username, mobile, password, grade FROM users WHERE username = ? OR mobile = ?";
    $stmt = $conn->prepare($sql);
    
    if ($stmt) {
        $stmt->bind_param("ss", $identifier, $identifier);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            
            // --- بررسی رمز عبور هش شده (امنیت) ---
            if (password_verify($pass, $row['password'])) {
                
                // ایجاد سشن
                $_SESSION['user_id'] = $row['id'];
                $_SESSION['namef'] = $row['fullname']; // نام سشن را با پروفایل یکی کردیم
                $_SESSION['username'] = $row['username'];
                $_SESSION['grade'] = $row['grade'];
                
                echo "<script>alert('خوش آمدید " . $row['fullname'] . "'); window.location.href = 'profile.php';</script>";
                exit();
                
            } else {
                echo "<script>alert('رمز عبور اشتباه است.'); window.history.back();</script>";
            }
        } else {
            echo "<script>alert('نام کاربری یا شماره موبایل یافت نشد.'); window.history.back();</script>";
        }
        $stmt->close();
    } else {
        echo "خطا در کوئری: " . $conn->error;
    }
}
$conn->close();
?>