// --- تنظیمات آزمون ---
const totalQuestions = 5;
const pointsPerQuestion = 4; 
const maxScore = totalQuestions * pointsPerQuestion; 

// پاسخ‌های صحیح
const correctAnswers = {
    q1: '5',         
    q2: 'پنج ضلعی',   
    q3: '4x - 12',     
    q4: '119',         
    q5: 'همه ی موارد' 
};

// --- متغیرهای تایمر ---
let seconds = 0;
let timerInterval;

// --- شروع برنامه ---
window.onload = function() {
    const isReview = localStorage.getItem('reviewMode') === 'true';
    const quizForm = document.getElementById('quizForm');

    if (isReview) {
        // --- حالت بررسی پاسخ ---
        if(quizForm) quizForm.style.display = 'block';
        
        // در حالت بررسی، تابع resetQuizUI را اجرا نکن تا تیک‌ها پاک نشوند
        checkReviewMode();
    } else {
        // --- حالت عادی آزمون ---
        if(quizForm) quizForm.style.display = 'block';
        
        // فقط در حالت عادی، صفحه را تمیز کن
        resetQuizUI();
    }
    
    startTimer();
    
    const finishBtn = document.getElementById('finishBtn');
    if (finishBtn) {
        finishBtn.addEventListener('click', finishExam);
    }
};

// تابع تمیز کردن ظاهر آزمون
function resetQuizUI() {
    // برداشتن تیک همه سوالات
    const inputs = document.querySelectorAll('input[type="radio"]');
    inputs.forEach(input => input.checked = false);
    
   
    const labels = document.querySelectorAll('.option-label');
    labels.forEach(label => {
        label.classList.remove('correct-answer');
        label.classList.remove('wrong-answer');
    });
    
    // مخفی کردن صفحه نتیجه
    const resultPage = document.getElementById('resultPage');
    if(resultPage) resultPage.style.display = 'none';
    
    // نمایش سوالات
    const quizContainer = document.getElementById('quiz-container');
    if(quizContainer) quizContainer.style.display = 'block';
}

function startTimer() {
    timerInterval = setInterval(() => {
        seconds++;
        const mins = Math.floor(seconds / 60);
        const secs = seconds % 60;
        const timerElement = document.getElementById('timer');
        if(timerElement) {
            timerElement.innerText = 
                `${mins.toString().padStart(2, '0')}:${secs.toString().padStart(2, '0')}`;
        }
    }, 1000);
}

// --- تابع پایان آزمون ---
function finishExam() {
    clearInterval(timerInterval);
    let scoreCount = 0;
    
    // --- ذخیره پاسخ‌های کاربر برای نمایش بعداً ---
    let userAnswers = {};
    for (let i = 1; i <= totalQuestions; i++) {
        const selected = document.querySelector(`input[name="q${i}"]:checked`);
        if (selected) {
            userAnswers[`q${i}`] = selected.value;
        }
    }
    localStorage.setItem('userAnswers', JSON.stringify(userAnswers));
    // -------------------------------------------------

    // محاسبه نمره
    for (let i = 1; i <= totalQuestions; i++) {
        const selected = document.querySelector(`input[name="q${i}"]:checked`);
        
        if (selected) {
            const userVal = selected.value.trim();
            const correctVal = correctAnswers[`q${i}`].trim();
            
            if (userVal === correctVal) {
                scoreCount++;
            }
        }
    }
    
    const finalScore = scoreCount * pointsPerQuestion;
    const status = (finalScore >= 10) ? 'pass' : 'fail';
    
    let message = '';
    if (finalScore >= 16) message = 'فوق‌العاده بودی!';
    else if (finalScore >= 12) message = 'خوب بود!';
    else if (finalScore >= 10) message = 'قابله قبوله';
    else message = 'نیاز به تلاش بیشتر داری.';
    
    const resultData = {
        score: finalScore,
        message: message,
        time: document.getElementById('timer').innerText,
        date: new Date().toLocaleDateString('fa-IR')
    };
    localStorage.setItem('examResult', JSON.stringify(resultData));
    
    const formData = new FormData();
    formData.append('exam_name', 'ریاضی');
    formData.append('score', finalScore);
    formData.append('duration', seconds);
    formData.append('status', status);
    
    fetch('save_exam.php', {
        method: 'POST',
        body: formData
    })
    .then(function(response) {
        return response.text();
    })
    .then(function(data) {
        showResultPage(finalScore, message);
    })
    .catch(function(error) {
        alert("خطا در ارتباط");
        showResultPage(finalScore, message);
    });
}

// --- تابع نمایش نتیجه ---
function showResultPage(score, message) {
    const quizContainer = document.getElementById('quiz-container');
    if (quizContainer) quizContainer.style.display = 'none';
    
    const resultPage = document.getElementById('resultPage');
    if (resultPage) {
        resultPage.style.display = 'block';
        document.getElementById('finalScoreText').innerText = score;
        document.getElementById('resultMessage').innerText = message;
        document.getElementById('resultTime').innerText = `زمان: ${document.getElementById('timer').innerText}`;
    } else {
        console.error("المان resultPage پیدا نشد!");
    }
}

// --- دکمه مشاهده پاسخ‌ها ---
document.getElementById('reviewBtn').addEventListener('click', function() {
    localStorage.setItem('reviewMode', 'true');
    location.reload();
});

// --- منطق حالت بررسی پاسخ‌ها ---
function checkReviewMode() {
    const isReview = localStorage.getItem('reviewMode') === 'true';
    
    if (isReview) {
        // مخفی کردن المان‌ها
        const finishBtn = document.getElementById('finishBtn');
        if(finishBtn) finishBtn.style.display = 'none';
        const header = document.querySelector('header');
        if(header) header.style.display = 'none';
        const resultPage = document.getElementById('resultPage');
        if(resultPage) resultPage.style.display = 'none';
        const quizContainer = document.getElementById('quiz-container');
        if(quizContainer) quizContainer.style.display = 'block';
        
        const backBtn = document.getElementById('backToProfileBtn');
        if (backBtn) {
            backBtn.style.display = 'block';
            backBtn.onclick = function() {
                localStorage.removeItem('reviewMode');
                window.location.href = 'profile.php'; 
            };
        }
        
        const inputs = document.querySelectorAll('input[type="radio"]');
        inputs.forEach(input => input.disabled = true);

        // --- بازیابی پاسخ‌های کاربر و زدن تیک ---
        const savedAnswers = JSON.parse(localStorage.getItem('userAnswers'));
        if (savedAnswers) {
            for (let i = 1; i <= totalQuestions; i++) {
                const ans = savedAnswers[`q${i}`];
                if (ans) {
                    const inputToCheck = document.querySelector(`input[name="q${i}"][value="${ans}"]`);
                    if (inputToCheck) {
                        inputToCheck.checked = true;
                    }
                }
            }
        }
        // ---------------------------------------------

        // رنگ آمیزی
        for (let i = 1; i <= totalQuestions; i++) {
            const qKey = 'q' + i;
            const correctVal = correctAnswers[qKey];
            
            const selectedInput = document.querySelector(`input[name="${qKey}"]:checked`);
            const correctInput = document.querySelector(`input[name="${qKey}"][value="${correctVal}"]`);
            
            if (correctInput) {
                correctInput.nextElementSibling.classList.add('correct-answer');
            }
            
            if (selectedInput && selectedInput.value !== correctVal) {
                selectedInput.nextElementSibling.classList.add('wrong-answer');
            }
        }
    }
}
// تابع پاک کردن حافظه و شروع مجدد
function resetExam() {
    localStorage.removeItem('examResult');
    localStorage.removeItem('reviewMode');
    location.reload();
}