
document.addEventListener("DOMContentLoaded", function () {
  const cards = document.querySelectorAll('.animate-on-scroll');
  const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        entry.target.classList.add('show');
        observer.unobserve(entry.target); 
      }
    });
  }, {
    threshold: 0.15,
    rootMargin: "0px 0px -50px 0px"
  });
  cards.forEach(card => {
    observer.observe(card);
  });
});


const fades = document.querySelectorAll('.fade');

const observer = new IntersectionObserver(entries => {
  entries.forEach(entry => {
    if (entry.isIntersecting) {
      entry.target.classList.add('show');
    }
  });
}, { threshold: 0.2 });

fades.forEach(el => observer.observe(el));

document.querySelectorAll('.btn-neon').forEach(btn => {
  btn.addEventListener('mouseenter', () => {
    btn.style.boxShadow = '0 0 35px rgba(34,211,238,.9)';
  });
  btn.addEventListener('mouseleave', () => {
    btn.style.boxShadow = '';
  });
});
const texts = [
  " سوالات تستی برای هر درس",
  "مشاهده روند پیشرفت",
  "مخصوص دانش اموزان متوسطه اول",
];

const typingElement = document.getElementById("typing-text");

let textIndex = 0;
let charIndex = 0;
let isDeleting = false;

const typingSpeed = 70;
const deletingSpeed = 40;
const delayAfterTyping = 1200;

function typeLoop() {
  const currentText = texts[textIndex];

  if (!isDeleting) {
    typingElement.textContent = currentText.slice(0, charIndex + 1);
    charIndex++;

    if (charIndex === currentText.length) {
      setTimeout(() => (isDeleting = true), delayAfterTyping);
    }
  } else {
    typingElement.textContent = currentText.slice(0, charIndex - 1);
    charIndex--;

    if (charIndex === 0) {
      isDeleting = false;
      textIndex = (textIndex + 1) % texts.length;
    }
  }

  setTimeout(
    typeLoop,
    isDeleting ? deletingSpeed : typingSpeed
  );
}

 typeLoop();


document.addEventListener('DOMContentLoaded', function() {
  const sliderWrapper = document.querySelector('.slider-wrapper');
  const cards = Array.from(document.querySelectorAll('.testimonial-card'));
  
  let currentIndex = 0;
  const intervalTime = 4000; 
  let isTransitioning = true; 

  function setupInfiniteLoop() {
      const containerWidth = document.querySelector('.slider-container').offsetWidth;
      const cardWidth = cards[0].offsetWidth;
      const style = window.getComputedStyle(cards[0]);
      const totalMargin = parseFloat(style.marginRight) + parseFloat(style.marginLeft);
      const moveAmount = cardWidth + totalMargin;
      
      const itemsVisible = Math.ceil(containerWidth / moveAmount);

      for (let i = 0; i < itemsVisible; i++) {
          const clone = cards[i].cloneNode(true);
          clone.setAttribute('aria-hidden', 'true'); 
          sliderWrapper.appendChild(clone);
      }
  }

  setupInfiniteLoop();

  function moveSlider() {
      if (!isTransitioning) return;

      const allCards = document.querySelectorAll('.testimonial-card');
      const cardWidth = allCards[0].offsetWidth;
      const style = window.getComputedStyle(allCards[0]);
      const totalMargin = parseFloat(style.marginRight) + parseFloat(style.marginLeft);
      const moveAmount = cardWidth + totalMargin;

      currentIndex++;

      sliderWrapper.style.transition = 'transform 0.5s ease-in-out';
      sliderWrapper.style.transform = `translateX(${currentIndex * moveAmount}px)`;

      const originalCount = cards.length;
      
      setTimeout(() => {
          if (currentIndex >= originalCount) {
              isTransitioning = false; 
              sliderWrapper.style.transition = 'none'; 
              currentIndex = 0; 
              sliderWrapper.style.transform = `translateX(0px)`; 
              
             
              setTimeout(() => {
                  isTransitioning = true; 
              }, 50);
          }
      }, 500);
  }

  
  setInterval(moveSlider, intervalTime);
  let resizeTimer;
  window.addEventListener('resize', () => {
      clearTimeout(resizeTimer);
      // پاک کردن کپی‌های قبلی
      const allCards = document.querySelectorAll('.testimonial-card');
      for (let i = cards.length; i < allCards.length; i++) {
          allCards[i].remove();
      }
      currentIndex = 0;
      sliderWrapper.style.transform = `translateX(0px)`;
      
      resizeTimer = setTimeout(() => {
          setupInfiniteLoop();
      }, 200);
  });
});
const openBtn = document.getElementById('openMenu');
const closeBtn = document.getElementById('closeMenu');
const sidebar = document.getElementById('sidebar');
const overlay = document.getElementById('overlay');

function openSidebar() {
    sidebar.classList.add('active');
    overlay.classList.add('active');
    document.body.style.overflow = 'hidden'; 
}

function closeSidebar() {
    sidebar.classList.remove('active');
    overlay.classList.remove('active');
    document.body.style.overflow = '';  
}

openBtn.addEventListener('click', openSidebar);
closeBtn.addEventListener('click', closeSidebar);
// بستن منو با کلیک روی فضای بیرون
overlay.addEventListener('click', closeSidebar);


  document.addEventListener("DOMContentLoaded", function() {
    
    const showAnswerBtn = document.getElementById('btnShowAnswer');
    const explanationBox = document.getElementById('explanationBox');
    const questionCard = document.getElementById('q1');
    
    // رویداد کلیک روی دکمه مشاهده پاسخ
    showAnswerBtn.addEventListener('click', function() {
      
      // 1. پیدا کردن گزینه انتخاب شده توسط کاربر
      const selectedOption = document.querySelector('input[name="q1"]:checked');
      const allLabels = questionCard.querySelectorAll('.option-label');
      
      // پاک کردن استایل‌های قبلی (برای بارهای بعدی)
      allLabels.forEach(label => {
        label.classList.remove('correct', 'wrong');
      });

      if (selectedOption) {
        const selectedLabel = document.querySelector(`label[for="${selectedOption.id}"]`);
        const isCorrect = selectedOption.getAttribute('data-correct') === 'true';

        if (isCorrect) {
          // اگر جواب درست بود
          selectedLabel.classList.add('correct');
        } else {
          // اگر جواب غلط بود
          selectedLabel.classList.add('wrong');
          
          // پیدا کردن و سبز کردن جواب درست
          const correctOption = document.querySelector('input[name="q1"][data-correct="true"]');
          const correctLabel = document.querySelector(`label[for="${correctOption.id}"]`);
          if (correctLabel) {
            correctLabel.classList.add('correct');
          }
        }
      } else {
       
        alert('لطفاً ابتدا یک گزینه را انتخاب کنید!');
        return; 
      }

      // 2. نمایش توضیح تشریحی
      explanationBox.classList.toggle('active');
      
      // تغییر متن دکمه
      if (explanationBox.classList.contains('active')) {
        showAnswerBtn.innerHTML = '<i class="bi bi-eye-slash"></i> بستن پاسخ';
      } else {
        showAnswerBtn.innerHTML = '<i class="bi bi-eye"></i> مشاهده پاسخ و تشریح';
      }
    });

  });


