<?php
session_start();
include 'backend/db.php';

$user_fullname = $_SESSION['namef']; 
$stmt = $conn->prepare("SELECT id FROM users WHERE fullname = ?");
$stmt->bind_param("s", $user_fullname);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

$chart_labels = [];
$chart_data = [];

if ($user) {
    $user_id = $user['id'];
    $chart_sql = "SELECT exam_date, score FROM exams WHERE user_id = ? ORDER BY exam_date ASC LIMIT 10";
    $stmt = $conn->prepare($chart_sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $chart_res = $stmt->get_result();
    
    while ($row = $chart_res->fetch_assoc()) {
        $dateObj = date_create($row['exam_date']);
        $chart_labels[] = date_format($dateObj, 'Y/m/d'); 
        $chart_data[] = $row['score'];
    }
}
?>

<div id="progress-section">
    <h2 class="section-title">روند پیشرفت تحصیلی</h2>
    <div class="glass-card" style="position: relative; height: 400px; width: 100%;">
        <canvas id="progressChart"></canvas>
    </div>
</div>

<script>
    setTimeout(function() {
        const ctx = document.getElementById('progressChart');
        
        if (!ctx) {
            console.error("Canvas not found!");
            return;
        }

        // دریافت داده‌ها از PHP
        const chartLabels = <?php echo json_encode($chart_labels); ?>;
        const chartData = <?php echo json_encode($chart_data); ?>;
        console.log("Labels:", chartLabels);
        console.log("Data:", chartData);

        if(window.myChartInstance) {
            window.myChartInstance.destroy();
        }
        if (typeof Chart !== 'undefined') {
            window.myChartInstance = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: finalLabels,
                    datasets: [{
                        label: 'نمره آزمون',
                        data: finalData,
                        borderColor: '#22d3ee',
                        backgroundColor: 'rgba(34, 211, 238, 0.1)',
                        borderWidth: 3,
                        pointBackgroundColor: '#a855f7',
                        pointBorderColor: '#fff',
                        pointRadius: 5,
                        fill: true,
                        tension: 0.4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            labels: {
                                color: '#f1f5f9',
                                font: { family: 'sans' }
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            max: 20,
                            grid: { color: 'rgba(255, 255, 255, 0.1)' },
                            ticks: { color: '#94a3b8' }
                        },
                        x: {
                            grid: { display: false },
                            ticks: { color: '#94a3b8' }
                        }
                    }
                }
            });
        } else {
            console.error("Chart.js is not defined!");
        }
    }, 100);
</script>